<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['mensagem'])) {
    $id_autor = $_SESSION['usuario']['id'];
    $nome_autor = $_SESSION['usuario']['nome'];
    $mensagem = trim($_POST['mensagem']);

    $stmt = $conn->prepare("INSERT INTO mensagens_prof (id_autor, nome_autor, mensagem) VALUES (?, ?, ?)");
    $stmt->bind_param("iss", $id_autor, $nome_autor, $mensagem);
    
    if ($stmt->execute()) {
        header("Location: painel_professor.php");
    } else {
        echo "Erro ao enviar a mensagem.";
    }
    exit;
} else {
    header("Location: painel_professor.php");
    exit;
}
?>